// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"

class FGSGSocketsServer;
class FToolBarBuilder;
class FMenuBuilder;

class FGreyscalegorillaConnector : public IModuleInterface
{
public:
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;

	int GetSettingsPortNumber();
	void PluginButtonClicked();

private:
	TUniquePtr<FGSGSocketsServer> MyRunnableInstance;
	void RegisterMenus();

private:
	TSharedPtr<class FUICommandList> PluginCommands;
};
